﻿param (
    [Parameter(Mandatory=$true)][string]$samaccountname,
    [Parameter(Mandatory=$true)][string]$newsamaccountname,
    [Parameter(Mandatory=$true)][string]$newupn,
    [Parameter(Mandatory=$true)][string]$name,
    [Parameter(Mandatory=$true)][string]$givenname,
    [Parameter(Mandatory=$true)][string]$surname,
    [Parameter(Mandatory=$true)][string]$displayname,
    [Parameter(Mandatory=$true)][string]$empnr,
    [Parameter(Mandatory=$true)][string]$userid
)

try{
    Get-ADUser -Filter "EmployeeNumber -eq '$empnr' -or UserPrincipalName -like '$userid@*' -or SamAccountName -eq '$samaccountname'" | Rename-ADObject -NewName $name -Passthru |
    % {Set-ADUser $_ -SamAccountName $newsamaccountname -UserPrincipalName $newupn -DisplayName $displayname -GivenName $givenname -Surname $surname -EmailAddress $newupn}
}
catch{
    Write-Host "Fout bij het wijzigen van de gebruikersnaam"
}
